/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.function.Function;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.criteria.ParameterExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

interface QueryParameterSetter {
    public static final QueryParameterSetter NOOP = (query, values, errorHandling) -> {};

    public void setParameter(Query var1, Object[] var2, ErrorHandling var3);

    public static enum ErrorHandling {
        STRICT{

            @Override
            public void execute(Runnable block) {
                block.run();
            }
        }
        ,
        LENIENT{

            @Override
            public void execute(Runnable block) {
                try {
                    block.run();
                }
                catch (RuntimeException rex) {
                    LOG.info("Silently ignoring", (Throwable)rex);
                }
            }
        };

        private static final Logger LOG;

        abstract void execute(Runnable var1);

        static {
            LOG = LoggerFactory.getLogger(ErrorHandling.class);
        }
    }

    public static class NamedOrIndexedQueryParameterSetter
    implements QueryParameterSetter {
        private static final Logger LOGGER = LoggerFactory.getLogger(NamedOrIndexedQueryParameterSetter.class);
        private final Function<Object[], Object> valueExtractor;
        private final Parameter<?> parameter;
        @Nullable
        private final TemporalType temporalType;

        NamedOrIndexedQueryParameterSetter(Function<Object[], Object> valueExtractor, Parameter<?> parameter, @Nullable TemporalType temporalType) {
            Assert.notNull(valueExtractor, (String)"ValueExtractor must not be null!");
            this.valueExtractor = valueExtractor;
            this.parameter = parameter;
            this.temporalType = temporalType;
        }

        @Override
        public void setParameter(Query query, Object[] values, ErrorHandling errorHandling) {
            Object value = this.valueExtractor.apply(values);
            if (this.temporalType != null) {
                if (this.parameter instanceof ParameterExpression) {
                    errorHandling.execute(() -> query.setParameter(this.parameter, (Date)value, this.temporalType));
                } else if (this.parameter.getName() != null && QueryUtils.hasNamedParameter(query)) {
                    errorHandling.execute(() -> query.setParameter(this.parameter.getName(), (Date)value, this.temporalType));
                } else {
                    Integer position = this.parameter.getPosition();
                    if (position != null && (query.getParameters().size() >= this.parameter.getPosition() || this.registerExcessParameters(query) || errorHandling == ErrorHandling.LENIENT)) {
                        errorHandling.execute(() -> query.setParameter(this.parameter.getPosition().intValue(), (Date)value, this.temporalType));
                    }
                }
            } else if (this.parameter instanceof ParameterExpression) {
                errorHandling.execute(() -> query.setParameter(this.parameter, value));
            } else if (this.parameter.getName() != null && QueryUtils.hasNamedParameter(query)) {
                errorHandling.execute(() -> query.setParameter(this.parameter.getName(), value));
            } else {
                Integer position = this.parameter.getPosition();
                if (position != null && (query.getParameters().size() >= position || errorHandling == ErrorHandling.LENIENT || this.registerExcessParameters(query))) {
                    errorHandling.execute(() -> query.setParameter(position.intValue(), value));
                }
            }
        }

        private boolean registerExcessParameters(Query query) {
            return query.getParameters().size() == 0 && NamedOrIndexedQueryParameterSetter.unwrapClass(query).getName().startsWith("org.eclipse");
        }

        private static Class<?> unwrapClass(Query query) {
            Class<?> queryType = query.getClass();
            try {
                return Proxy.isProxyClass(queryType) ? query.unwrap(null).getClass() : queryType;
            }
            catch (RuntimeException e) {
                LOGGER.warn("Failed to unwrap actual class for Query proxy.", (Throwable)e);
                return queryType;
            }
        }
    }
}

